# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
try:
     import pygtk
     pygtk.require("2.0")
except:
      pass
try:
    import gtk
    import gtk.glade
except:
    sys.exit(1)

import os, sys


def find_program_file(path):
    """Finds a program file, for example, a png included with the program.
    First looks for it in files/ under the parent directory of the parent directory
    of ear_candy.py
    Then looks for it in /usr/share/earcandy
    Returns the path of the file"""
    if os.path.exists(os.path.join(os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "files",path)):
        return os.path.join(os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "files",path)
    else:
        return os.path.join(sys.prefix, "share/earcandy", path)
    
class GladeWindow():

    def __init__(self, glade_file, window_name, parent=None):
        self.return_value = None
        self.parent = parent
        self.wtree = gtk.glade.XML(find_program_file(glade_file))
        self.window = self.wtree.get_widget(window_name)
        self.window.connect("destroy", self.on_destroy)
        if parent: self.window.set_transient_for(parent)
        
    def run(self):
        self.window.show()   
        gtk.main()
        return self.return_value

    def stop(self):
        self.window.destroy()
        gtk.main_quit()

    def on_destroy(self, widget, data=None):
        self.stop()
